package gov.va.med.mhv.calendar.validator;

import gov.va.med.mhv.calendar.dto.ToDoTaskDTO;
import gov.va.med.mhv.calendar.enums.ReminderIntervalEnumeration;
import gov.va.med.mhv.common.api.util.ResponseUtil;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;

import org.springframework.stereotype.Component;


@Component
public class ToDoTaskValidator extends Validator {
	
	private static final String REMINDER_DATE="Reminder Date";
	private static final String TODO_NAME="To-Do Name";
	private static final String TODO_DESC="Description/Notes";
	private static final String TODO_DUE="Due Date";
	

	
	public ResponseUtil<ToDoTaskDTO> fieldValidations(ToDoTaskDTO toDoTaskDTO) {
		ResponseUtil<ToDoTaskDTO> response = new ResponseUtil<ToDoTaskDTO>();
		
		LinkedHashMap<String, String> validationErrors = new LinkedHashMap<String, String>();
		validateFields(toDoTaskDTO, validationErrors);
		validateReminderDate(toDoTaskDTO, validationErrors);
		response.setValidationErrors(validationErrors);
	
		return response;
		
	}
	

	private void validateFields(ToDoTaskDTO toDoTaskDTO, LinkedHashMap<String, String> validationErrors) {
		if ((toDoTaskDTO.getSubject() == null) || (toDoTaskDTO.getSubject().isEmpty()) ){
			
			validationErrors.put(TODO_NAME, TODO_NAME + " is required.");
		}
		
		if (toDoTaskDTO.getSubject() != null && toDoTaskDTO.getSubject().length() > 50) {
			
			validationErrors.put(TODO_NAME, TODO_NAME + " has exceeded the maximun length.");
		}
		
		if (toDoTaskDTO.getDescription() != null && toDoTaskDTO.getDescription().length() > 255) {
			
			validationErrors.put(TODO_DESC, TODO_DESC + "  has exceeded the maximun length.");
		}
		
		//Commented this to resolve defect #310764
		/*
		if (toDoTaskDTO.getDueDate() != null) {
			
			String dueDate= dateToString(toDoTaskDTO.getDueDate(),"yyyyMMdd");
			Calendar cal =Calendar.getInstance();
			String currentDate = dateToString(cal.getTime(),"yyyyMMdd");
			
			if(Integer.parseInt(dueDate) < Integer.parseInt(currentDate)) {
		
			    validationErrors.put(TODO_DUE, TODO_DUE + "  should be greater than today's date.");
		    }
	
	    }  */
	}
	
	private static String dateToString (Date date,String format){
		String stringDate="";
		try{
			if(date != null){
			   SimpleDateFormat sdf = new SimpleDateFormat(format);
			   stringDate =sdf.format(date);
			}
		}catch(Exception e){
			throw new RuntimeException("Invalid Date format");
		}
		return stringDate;
	}

	
	private void validateReminderDate(ToDoTaskDTO toDoTaskDTO, LinkedHashMap<String, String> validationErrors) {


		if (toDoTaskDTO.getReminderInterval() != null) {
			Calendar reminderCal = Calendar.getInstance();
			String remInt = toDoTaskDTO.getReminderInterval();
			

			if (toDoTaskDTO.getDueDate() == null && remInt != null) {
				validationErrors.put(REMINDER_DATE, REMINDER_DATE + "You must enter a due date if you want to set a reminder.");
				return;
			}
			
			if (remInt.equals(ReminderIntervalEnumeration.D1)) {
				reminderCal.add(Calendar.DATE, -1);
			} else if (remInt.equals(ReminderIntervalEnumeration.D2)) {
				reminderCal.add(Calendar.DATE, -2);
			} else if (remInt.equals(ReminderIntervalEnumeration.D3)) {
				reminderCal.add(Calendar.DATE, -3);
			} else if (remInt.equals(ReminderIntervalEnumeration.D4)) {
				reminderCal.add(Calendar.DATE, -4);
			} else if (remInt.equals(ReminderIntervalEnumeration.W1)) {
				reminderCal.add(Calendar.DATE, -7);
			} else if (remInt.equals(ReminderIntervalEnumeration.W2)) {
				reminderCal.add(Calendar.DATE, -14);
			}

			Calendar cutOffDateForReminders = Calendar.getInstance();
			//CalendarUtil.setFirstSecondOfDay(cutOffDateForReminders);
			if (reminderCal.after(cutOffDateForReminders)) {
				// Set time to midnight and set the reminder date
			} else {
				// if reminder date is before today's date we should tell the user
				// that their reminder won't work because it has already passed.
				
				validationErrors.put(REMINDER_DATE, REMINDER_DATE + "The reminder date for this event has already passed. Please change the reminder interval or the due date.");
			}		

		}

	}
	
	
}


